class AddGst {
  List<Gst>? gst;

  AddGst({this.gst});

  AddGst.fromJson(Map<String, dynamic> json) {
    if (json['gst'] != null) {
      gst = <Gst>[];
      json['gst'].forEach((v) {
        gst!.add(new Gst.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.gst != null) {
      data['gst'] = this.gst!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Gst {
  int? id;
  int? gstEnable;
  String? gstNumber;
  String? companyName;
  String? address;
  String? gstPer;
  String? createdAt;
  String? updatedAt;

  Gst(
      {this.id,
      this.gstEnable,
      this.gstNumber,
      this.companyName,
      this.address,
      this.gstPer,
      this.createdAt,
      this.updatedAt});

  Gst.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    gstEnable = json['gst_enable'];
    gstNumber = json['gst_number'];
    companyName = json['company_name'];
    address = json['address'];
    gstPer = json['gst_per'];
    createdAt = json['created_at'];
    updatedAt = json['updated_at'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['gst_enable'] = this.gstEnable;
    data['gst_number'] = this.gstNumber;
    data['company_name'] = this.companyName;
    data['address'] = this.address;
    data['gst_per'] = this.gstPer;
    data['created_at'] = this.createdAt;
    data['updated_at'] = this.updatedAt;
    return data;
  }
}
